#include <iostream>
using namespace std;

const int maxN = 3e5 + 7;
int seg[4 * maxN], lz[4 * maxN];
int a[maxN];

void build(int v, int l, int r) {
    lz[v] = seg[v] = -1e7;
    if (l == r) {
        if (a[l] == 1) {
            seg[v] = 0;
        }
        return;
    }
    int m = (l + r) / 2;
    build(2 * v, l, m);
    build(2 * v + 1, m + 1, r);
    seg[v] = max(seg[2 * v], seg[2 * v + 1]);
}

void push(int v) {
    seg[v] = max(seg[v], lz[v]);
    lz[2 * v] = max(lz[2 * v], lz[v]);
    lz[2 * v + 1] = max(lz[2 * v + 1], lz[v]);
}

void add(int v, int l, int r, int p) {
    push(v);
    if (l == r && l == p) {
        seg[v]++; return;
    }
    int m = (l + r) / 2;
    if (p <= m) {
        push(2 * v + 1);
        add(2 * v, l, m, p);
    }
    else {
        push(2 * v);
        add(2 * v + 1, m + 1, r, p);
    }
    seg[v] = max(seg[2 * v], seg[2 * v + 1]);
}

void upd(int v, int l, int r, int L, int R, int x) {
    push(v);
    if (L > r || l > R) {
        return;
    }
    if (L <= l && r <= R) {
        lz[v] = x;
        push(v);
        return;
    }
    int m = (l + r) / 2;
    upd(2 * v, l, m, L, R, x);
    upd(2 * v + 1, m + 1, r, L, R, x);
    seg[v] = max(seg[2 * v], seg[2 * v + 1]);
}

int calc(int v, int l, int r, int L, int R) {
    push(v);
    if (r < L || R < l) {
        return -1e7;
    }
    if (L <= l && r <= R) {
        return seg[v];
    }
    int m = (l + r) / 2;
    return max(calc(2 * v, l, m, L, R),
               calc(2 * v + 1, m + 1, r, L, R));
}

int Slamke(int n, int* A, int M, int* t, int* x, int* y) {
    for (int i = 1; i <= n; i++) {
        a[i] = A[i];
    }
    build(1, 1, n);
    for (int q = 1; q <= M; q++) {
        if (t[q] == 2) {
            add(1, 1, n, x[q]);
            continue;
        }
        int mx = calc(1, 1, n, x[q], y[q]);
        upd(1, 1, n, x[q], y[q], mx);
    }
    push(1); return seg[1];
}